/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers;

import java.awt.geom.Rectangle2D;
import replicatorg.app.ui.SimulationWindow;
import replicatorg.app.ui.SimulationWindow2D;
import replicatorg.drivers.DriverBaseImplementation;
import replicatorg.drivers.RetryException;
import replicatorg.util.Point5d;

public class SimulationDriver
extends DriverBaseImplementation {
    private SimulationWindow simulation;

    public void setSimulationBounds(Rectangle2D.Double bounds) {
        if (this.isSimulating()) {
            this.simulation.setSimulationBounds(bounds);
        }
    }

    public boolean isSimulating() {
        return this.simulation != null;
    }

    public void createWindow() {
        this.simulation = new SimulationWindow2D();
        this.simulation.setVisible(true);
    }

    public void destroyWindow() {
        if (this.simulation != null) {
            this.simulation.setVisible(false);
            this.simulation.dispose();
        }
        this.simulation = null;
    }

    @Override
    public void dispose() {
        this.destroyWindow();
        super.dispose();
    }

    @Override
    public void queuePoint(Point5d p) throws RetryException {
        this.simulation.queuePoint(p);
        super.queuePoint(p);
    }

    public void homeXYZ() throws RetryException {
        this.queuePoint(new Point5d());
    }

    public void homeXY() throws RetryException {
        Point5d pos = this.getCurrentPosition(false);
        pos.setX(0.0);
        pos.setY(0.0);
        this.queuePoint(pos);
    }

    public void homeX() throws RetryException {
        Point5d pos = this.getCurrentPosition(false);
        pos.setX(0.0);
        this.queuePoint(pos);
    }

    public void homeY() throws RetryException {
        Point5d pos = this.getCurrentPosition(false);
        pos.setY(0.0);
        this.queuePoint(pos);
    }

    public void homeZ() throws RetryException {
        Point5d pos = this.getCurrentPosition(false);
        pos.setZ(0.0);
        this.queuePoint(pos);
    }

    @Override
    protected Point5d reconcilePosition() {
        return new Point5d();
    }
}

